
%%
%% This is file `thesisAdvisor.cls',
%% generated with the docstrip utility.
%%
%%   Copyright © 2008-2009 Vafa Khalighi
%%  
%%   Edited by  Mojtaba Hajipour     
%%  
%%   License information appended.
%% 
%% 
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{thesisAdvisor}
              [2020/12/25 v0.1
 Persian thesis document class in XeLaTeX]
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}
\ProcessOptions
\LoadClass{book}
\def\university#1{\gdef\@university{#1}}
\def\department#1{\gdef\@department{#1}}
\def\degree#1{\gdef\@degree{#1}}
\def\thesisdate#1{\gdef\@thesisdate{#1}}
\def\defenddate#1{\gdef\@defenddate{#1}}
\def\supervisor#1{\gdef\@supervisor{#1}}
\def\supervisorM#1{\gdef\@supervisorM{#1}}
\def\advisorM#1{\gdef\@advisorM{#1}}
\def\advisor#1{\gdef\@advisor{#1}}
\def\refreeinA#1{\gdef\@refreeinA{#1}}
\def\refreeinB#1{\gdef\@refreeinB{#1}}
\def\refreeoutA#1{\gdef\@refreeoutA{#1}}
\def\refreeoutB#1{\gdef\@refreeoutB{#1}}
\def\tit#1{\gdef\@tit{#1}}
\def\type#1{\gdef\@type{#1}}
\def\city#1{\gdef\@city{#1}}
\def\subject#1{\gdef\@subject{#1}}
\def\field#1{\gdef\@field{#1}}
\def\department#1{\gdef\@department{#1}}
\def\DGC#1{\gdef\@DGC{#1}}

\def\latintitle#1{\gdef\@latintitle{#1}}
\def\latinauthor#1{\gdef\@latinauthor{#1}}
\def\latindegree#1{\gdef\@latindegree{#1}}
\def\latinsubject#1{\gdef\@latinsubject{#1}}
\def\latinfaculty#1{\gdef\@latinfaculty{#1}}
\def\latinthesisdate#1{\gdef\@latinthesisdate{#1}}
\def\latintype#1{\gdef\@latintype{#1}}
\def\latindefenddate#1{\gdef\@latindefenddate{#1}}
\def\latinsupervisor#1{\gdef\@latinsupervisor{#1}}
\def\latinadvisorM#1{\gdef\@latinadvisorM{#1}}
\def\latinsupervisorM#1{\gdef\@latinsupervisorM{#1}}
\def\latinadvisor#1{\gdef\@latinadvisor{#1}}
\def\latinrefreeinA#1{\gdef\@latinrefreeinA{#1}}
\def\latinrefreeinB#1{\gdef\@latinrefreeinB{#1}}
\def\latinDGC#1{\gdef\@latinDGC{#1}}
\def\latincity#1{\gdef\@latincity{#1}}
\def\latinuniversity#1{\gdef\@latinuniversity{#1}}
\def\pagenumber#1{\gdef\@pagenumber{#1}}
\def\email#1{\gdef\@email{#1}}
\def\lang#1{\gdef\@lang{#1}}
\def\supervisoremail#1{\gdef\@supervisoremail{#1}}
%%=================================================
\def\makefatitle{\begin{titlepage}
%\topmargin=-30pt
\vspace{-1cm}\centerline{{\includegraphics[height=4cm]{logo.png}}}
\vspace{3pt}
\centerline{\Large \bfseries\@university}
\vspace{8pt}
\centerline{\Large\bfseries\@department}
\vskip .5cm
{\large\bfseries\writtenfor
\@degree}
{\large\bfseries{در رشته}}
\vskip .2cm

\centerline{\large \bfseries\@subject%
%، گرایش
%\@field
}
\vskip 1cm
%\baselineskip=.750cm
\centerline{\Large \bfseries\onvan}


\vskip .4cm

{\Huge\titr \@title}\par
{\Huge\titr \@tit}
\vskip .8cm



{\large%
  \by}\par
\par
{\bf\Large \@author}\par

{\large
  \undersupervision\par
 \bf\Large \@supervisor}\par

{\large
  \coadvisor\par
 \bf\Large \@advisor}

\vskip 8mm
\par
%%\vskip 1cm
{\large \@thesisdate}
%\par
%\vskip 1cm

%\par
%{\large\bfseries\universityof\space\@university \par\@city}
%\vfill
\end{titlepage}%
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55555
\def\approval{
\begin{titlepage}
\begin{center}
\vspace{-1cm}\centerline{{\includegraphics[height=3cm]{logo.png}}}\vskip3mm
{\large\bfseries \@university}\\\vspace{8pt}
{\large\bfseries \@department}
\vskip 1.3cm
{\large\bfseries\@type\space\@degree}
\vskip 1cm
{\Large\titr \@title}\par
{\Large\titr \@tit}
\vskip 1cm
\by:\space\@author
\end{center}
\vskip 1cm
در تاریخ 
\@defenddate
کمیته تخصصی زیر مورد بررسی و تصویب نهایی قرار گرفت.
\vskip 1cm
\begin{tabular}{p{10cm}p{2cm}}
%اگر اساتید راهنما یا مشاور داردید باید این قسمت را خوب بررسی کنید
\textbf{استاد راهنما}: \@supervisor  & امضاء: \\[1.5cm]
\textbf{استاد مشاور}: \@advisor  & امضاء: \\[1.5cm]
\textbf{استاد ممتحن داخلی ۱}: \@refreeinA & امضاء: \\[1.5cm]
\textbf{استاد ممتحن داخلی ۲}: \@refreeinB & امضاء: \\[1.5cm]
%\textbf{استاد ممتحن خارجی ۱}: \@refreeoutA & امضاء: \\[1.5cm]
%\textbf{استاد ممتحن خارجی ۲}: \@refreeoutB & امضاء:
\textbf{سرپرست تحصیلات تکمیلی}: \@DGC & امضاء: \\[1.5cm]
\end{tabular}
\end{titlepage}
%%%%%%%%%%%%5555
\newpage
%\hline\par
\begin{flushright}
\vspace{-4cm}\rightline{{\includegraphics[height=2.5cm]{logo.png}\space\space}}
\vskip -3mm 
{\small\@university}
\end{flushright}
\begin{center}
\vspace{-2cm} { \Large \bf تعهدنامه اصالت اثر}\\
\vspace{-2cm} { \bf به نام خدا}
\end{center}
\begin{flushleft}
تاریخ: \@defenddate
\end{flushleft}
%\chapter*{}
\par
\vspace{2cm}
اينجانب \@author\ متعهد مي‌شوم كه مطالب مندرج در اين پايان نامه حاصل كار پژوهشي اینجانب بوده و صحت و سقم آنها بر عهده ‏ی خودم می ‏باشد و به دستاوردهاي ديگران كه در اين پژوهش از آنها استفاده شده است مطابق مقررات و روال متعارف ارجاع و در فهرست منابع و مآخذ ذكر گرديده است. اين پایان نامه قبلاً براي احراز هيچ مدرك هم‌سطح يا بالاتر ارائه نگرديده است. \\
در صورت اثبات تخلف در هر زمان، مدرك تحصيلي صادر شده توسط  \@university\ از درجه اعتبار ساقط بوده و دانشگاه  حق پيگيري قانوني خواهد داشت. \\[7pt]
\begin{center}
 \@author ~~~ \\[2pt]
 امضاء~~~
\end{center}
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
%
\newcommand{\preface}{
\chapter*{مقدمه}
%\pagenumbering{arabic}\setcounter{page}{1}
\rhead{مقدمه}
\addcontentsline{toc}{chapter}{مقدمه}
\def\theequation{\arabic{equation}}}
%
\newcommand{\EndPreface}{
\def\theequation{\arabic{equation}-\thechapter}}

\newcommand{\acknowledge}{
\chapter*{سپاس‌گزاری}
\rhead{سپاس‌گزاری}
\addcontentsline{toc}{chapter}{سپاس‌گزاری}}

\def\titlepage{\newpage\centering
  \thispagestyle{empty}
  \parindent 0pt \parskip 10pt plus 1fil minus 1fil
  \def\baselinestretch{1}\@normalsize\vbox to \vsize\bgroup\vbox to 9in\bgroup}
\def\endtitlepage{\par\kern 0pt\egroup\vss\egroup\newpage}

\def\signature#1#2{\par\noindent#1\dotfill\null\\*
  {\raggedright #2\par}}

\thispagestyle{empty}
\def\abstract{\subsection*{\abstractname}\small
\@normalsize}
\def\endabstract{\par}

\pagenumbering{adadi}
\def\keywords#1{\par\vspace{5mm}
\noindent {\textbf{واژه‌های کلیدی:}} {\textit{ #1}}}

\def\latinkeywords#1{\par \vspace{5mm}
\noindent {\textbf{Keywords:}} { #1}}

\font\titlefont=cmssbx10 scaled 2074
\font\supervisorfont=cmbxti10 
 %===========================================
\def\makelatintitle{\begin{titlepage}
{\includegraphics[height=4cm]{logo.png}}
\centerline{\large\bfseries\@latinuniversity} 
%\vskip 1.5cm
%\addtolength{\baselineskip}{5mm}
{\large\bfseries\@latinfaculty}\space 
\large\bfseries
\vskip 5mm
{\latinwrittenfor \space
\large\@latindegree}{\space\large\bfseries{in}}
\vskip .2cm
\centerline{\large \bfseries\@latinsubject}
\vskip 0.7cm
\baselineskip=.750cm
{\titlefont \@latintitle} \par
\addtolength{\baselineskip}{-5mm}
\vskip 15mm

Supervisor \par
{\Large \@latinsupervisor}
\vskip 4mm
 Advisor\par
{\Large \@latinadvisor}
\vskip 5mm
{\bfseries\latinby}\par
{\Large \@latinauthor}\par
\vskip 5mm

\par
\vskip 1cm

\par
\vskip 1cm
%\@latincity

{\@latinthesisdate}
\par
\vskip 1cm

\par


\vfill
\end{titlepage}%
}
%\def\department{دانشکده علوم ریاضی }


\def\onvan{عنوان}

\def\writtenfor{ پایان‌نامه   }

\def\undersupervision{استاد راهنما}

\def\coadvisor{استاد مشاور}

\def\by{نگارش}
%\def\departmentof{گروه}
%\def\universityof{دانشگاه}
\def\latinby{by}
\def\latinwrittenfor{A Thesis 
Submitted in Partial Fulfillment of the Requirements 
for the}
\def\latinundersupervision{Under supervision of}

\def\makelatinabstract{\newpage
\thispagestyle{empty}
\vskip 15mm
\hspace{0.5cm}
\vskip 1cm
{\bfseries\large Abstract}\par
}

%\def\endlatinabstract{\newpage}
%% 
%% Copyright © 2008-2009      by Vafa Khalighi     <vafa@users.berlios.de>
%% 
%% Distributable under the LaTeX Project Public License,
%% version 1.3c or higher (your choice). The latest version of
%% this license is at: http://www.latex-project.org/lppl.txt
%% 
%% This work is "maintained" (as per LPPL maintenance status)
%% by Vafa Khalighi.
%% 
%% 
%% 
%% 
%%
%% End of file `xepersian-thesis.cls'.
